function [model] = train_LSSVM(Xtrain,Ytrain,varargin)
%Trains an LSSVM.
%
%Xtrain is a Nxd matrix and Ytrain Nx1.
%The return value model is an object containing the LSSVM.
%
%Optional parameter:
%gsearch  1 if grid search is done. Default 1 (grid search)
%         Gridsearch is much more accurate but slower.
%

if size(Xtrain,1) == 0 | size(Ytrain,1) == 0
  model = [];
  return;
end

gridsearch = 1;
if nargin > 2
  gridsearch = varargin{1};
end

model = initlssvm(Xtrain,Ytrain,'f',10,0.2,'RBF_kernel',['original'],'MATLAB');
model = bay_initlssvm(model);
model = bay_optimize(model,3,'eign',50);  
model = bay_optimize(model,2,'eign',50);
  
  
if gridsearch == 1
    model = tunelssvm(model);
end
  
model = trainlssvm(model);
  




