function [pred,MSE] = LSSVMtest(Xtest,Ytest,model)
%
%Params:
%Xtest The test inputs.
%Ytest The corresponding outputs. [] no output in which case only
%      the predictions pred are returned.
%

if size(Xtest,1) == 0 | length(model) == 0 
  pred = NaN;
  return;
end

[pred] = simlssvm(model,Xtest);

if length(Ytest) > 0
  MSE = sum((Ytest - pred).^2)/size(pred,1);
end

