function [error, k] = LL(x, y, varargin)



warning off;

if length(x) == 0

  error = inf;
  return;

end

[rows, columns] = size(x);

z = sum(x.^2);
x = x(:,find(z > 0));

if sum(cumsum(x(:,end)) - (1:rows)') ~= 0

  x = [x ones(rows,1)];

  columns = columns + 1;

end


if nargin > 2

  neigh = varargin{1};

else

  neigh = ceil(rows/10);

end



if neigh < columns

  neigh = columns;

end



if neigh > rows

  neigh = rows - 1;

end



if max(size(y)) ~= rows

  disp('Output must have as many rows as the input data!');

  error = inf;

  k = inf;

  return;

end



[sorted, index] = sort(squareform(pdist(x, 'euclidean')));



everythingOK = 0;

minNeigh = columns;



if minNeigh > neigh

  minNeigh = neigh;

end



while everythingOK == 0

  errors = ones(rows,neigh) * inf;



  for cc = minNeigh:neigh

    for i = 1:rows

      errors(i, cc) = ...
        (x(i,:) * (x(index(2:cc+1,i),:) \ y(index(2:cc+1,i))) - y(i)) .^2;

    end

   

    if isnan(mean(errors(:,cc),1))

      minNeigh = minNeigh + 1;
      everythingOK = 0;

      break;

    else

      everythingOK = 1;

    end

  end % For columns

end % While loop



[error, k] = min(mean(errors,1));



warning on;



