function [error, k] = KNN(x, y, varargin)


[rows, columns] = size(x);

neigh = ceil(rows/10);

if nargin > 2 

  if length(varargin{1}) > 0

    neigh = varargin{1};

    if neigh > rows

      neigh = rows - 1;

    end

  end

end


if max(size(y)) ~= rows

  disp('Output must have as many rows as the input data!');

  error = inf;

  k = inf;

  return;

end



[sorted, index] = sort(squareform(pdist(x, 'euclidean')));



if neigh == 1

  [error, k] = min(mean((y(index(2, :)) - y) .^2, 1));

else

  [error, k] = min(mean(((cumsum(y(index(2:neigh+1, :)),1)' ./ ...
    (ones(rows,1) * (1:neigh))) - y * ones(1,neigh)) .^2, 1));

end

