 function varargout = GUI(varargin)
% GUI M-file for GUI.fig
%      GUI, by itself, creates a new GUI or raises the existing
%      singleton*.
%
%      H = GUI returns the handle to a new GUI or the handle to
%      the existing singleton*.
%
%      GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GUI.M with the given input arguments.
%
%      GUI('Property','Value',...) creates a new GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before GUI_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help GUI

% Last Modified by GUIDE v2.5 15-Nov-2006 18:33:15

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before GUI is made visible.
function GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GUI (see VARARGIN)

% Choose default command line output for GUI
handles.output = hObject;
handles.kmaxknn=[];
handles.kmaxLL=[];
handles.kmaxboot=[];
handles.inputs_selected=[];
handles.scalings=[];
handles.projection = [];
handles.modellssvm=[];
handles.MSE=[];
handles.pred=[];
guidata(hObject,handles);
addpath './LSSVM';

% Update handles structure


% UIWAIT makes GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double


% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function traininput_Callback(hObject, eventdata, handles)
% hObject    handle to traininput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of traininput as text
%        str2double(get(hObject,'String')) returns contents of traininput as a double


% --- Executes during object creation, after setting all properties.
function traininput_CreateFcn(hObject, eventdata, handles)
% hObject    handle to traininput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit9_Callback(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit9 as text
%        str2double(get(hObject,'String')) returns contents of edit9 as a double
%handle = guihandle;
%handle.selected_inputs=[];
%handle.output = hObject;

% --- Executes during object creation, after setting all properties.
function edit9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function trainoutput_Callback(hObject, eventdata, handles)
% hObject    handle to trainoutput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of trainoutput as text
%        str2double(get(hObject,'String')) returns contents of trainoutput as a double


% --- Executes during object creation, after setting all properties.
function trainoutput_CreateFcn(hObject, eventdata, handles)
% hObject    handle to trainoutput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit12_Callback(hObject, eventdata, handles)
% hObject    handle to edit12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit12 as text
%        str2double(get(hObject,'String')) returns contents of edit12 as a double


% --- Executes during object creation, after setting all properties.
function edit12_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit13_Callback(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit13 as text
%        str2double(get(hObject,'String')) returns contents of edit13 as a double


% --- Executes during object creation, after setting all properties.
function edit13_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[f,pathstr] = uigetfile('*.*','Load training inputs');
if pathstr == 0
    return;
end
set(handles.traininput,'string',[pathstr f]); 

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[f,pathstr] = uigetfile('*.*','Load training outputs');
if pathstr == 0
    return;
end
set(handles.trainoutput,'string',[pathstr f]); 


% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function testinput_Callback(hObject, eventdata, handles)
% hObject    handle to testinput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of testinput as text
%        str2double(get(hObject,'String')) returns contents of testinput as a double


% --- Executes during object creation, after setting all properties.
function testinput_CreateFcn(hObject, eventdata, handles)
% hObject    handle to testinput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function testoutput_Callback(hObject, eventdata, handles)
% hObject    handle to testoutput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of testoutput as text
%        str2double(get(hObject,'String')) returns contents of testoutput as a double


% --- Executes during object creation, after setting all properties.
function testoutput_CreateFcn(hObject, eventdata, handles)
% hObject    handle to testoutput (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in pushbutton5.
function pushbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[f,pathstr] = uigetfile('*.*','Load test inputs');
if pathstr == 0
    return;
end
set(handles.testinput,'string',[pathstr f]); 

% --- Executes on button press in pushbutton6.
function pushbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton6 (see GCBO)
% eventdata  res
%erved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[f,pathstr] = uigetfile('*.*','Load test outputs');
if pathstr == 0
    return;
end
set(handles.testoutput,'string',[pathstr f]); 

% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2


contents = get(hObject,'String');
if size(contents,1) == 1
  s = contents;
else
  s = contents{get(hObject,'Value')};
end


% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in cost.
function cost_Callback(hObject, eventdata, handles)
% hObject    handle to cost (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns cost contents as cell array
%        contents{get(hObject,'Value')} returns selected item from cost


 contents = get(hObject,'String');
 if size(contents,1) == 1
   s = contents;
 else
   s = contents{get(hObject,'Value')};
 end
 handles=guidata(hObject);

if isequal(s,'bootstrap 632')
     if length(handles.kmaxboot) == 0
         set(handles.parfield,'string','Default');
     else
         set(handles.parfield,'string',num2str(handles.kmaxboot));
     end
     set(handles.parfield,'enable','on');
end

  if isequal(s,'LL')
     if length(handles.kmaxLL) == 0
         set(handles.parfield,'string','Default');
     else
         set(handles.parfield,'string',num2str(handles.kmaxLL));
     end
     set(handles.parfield,'enable','on');
  end
 
  if isequal(s,'k-NN')
     if length(handles.kmaxknn) == 0
         set(handles.parfield,'string','Default');
     else
         set(handles.parfield,'string',num2str(handles.kmaxknn));
     end
     set(handles.parfield,'enable','on');
     set(handles.method,'enable','on');
 end

if isequal(s,'MI')
  set(handles.parfield,'enable','off');
end

% --- Executes during object creation, after setting all properties.
function cost_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cost (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in method.
function method_Callback(hObject, eventdata, handles)
% hObject    handle to method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns method contents as cell array
%        contents{get(hObject,'Value')} returns selected item from method

contents = get(hObject,'String');
s = contents{get(hObject,'Value')};
set(handles.parfield,'enable','on');
set(handles.cost,'enable','on');
handles=guidata(hObject);

if isequal(s,'forward-backward selection') | isequal(s,'best first')
    set(handles.cost,'String',{'k-NN';'bootstrap 632';'LL'});
    set(handles.cost,'Value',1)
     if length(handles.kmaxknn) == 0
         set(handles.parfield,'string','Default');
     else
         set(handles.parfield,'string',num2str(handles.kmaxknn));
     end
end

if isequal(s,'forward selection') | isequal(s,'backward selection')
    set(handles.cost,'String',{'k-NN';'bootstrap 632';'LL';'MI'});
end

if isequal(s,'genetic IS')
    set(handles.cost,'String',{'k-NN';'bootstrap 632';'LL'});
    set(handles.cost,'Value',1);
     if length(handles.kmaxknn) == 0
         set(handles.parfield,'string','Default');
     else
         set(handles.parfield,'string',num2str(handles.kmaxknn));
     end
end

if isequal(s,'LARS')
    set(handles.cost,'String',{'LL'});
    set(handles.cost,'Value',1);
     if length(handles.kmaxLL) == 0
         set(handles.parfield,'string','Default');
     else
         set(handles.parfield,'string',num2str(handles.kmaxLL));
     end
end

if isequal(s,'ARD')
   set(handles.parfield,'enable','off');
   set(handles.cost,'enable','off');
end

if isequal(s,'PLS')
   set(handles.parfield,'enable','off');
   set(handles.cost,'enable','off');
end

if isequal(s,'scaling')
    set(handles.cost,'String',{'k-NN'});
    set(handles.cost,'Value',1);
     if length(handles.kmaxknn) == 0
         set(handles.parfield,'string','Default');
     else
         set(handles.parfield,'string',num2str(handles.kmaxknn));
     end
end


% --- Executes during object creation, after setting all properties.
function method_CreateFcn(hObject, eventdata, handles)
% hObject    handle to method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit17_Callback(hObject, eventdata, handles)
% hObject    handle to edit17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit17 as text
%        str2double(get(hObject,'String')) returns contents of edit17 as a double


% --- Executes during object creation, after setting all properties.
function edit17_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit18_Callback(hObject, eventdata, handles)
% hObject    handle to edit18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit18 as text
%        str2double(get(hObject,'String')) returns contents of edit18 as a double


% --- Executes during object creation, after setting all properties.
function edit18_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit19_Callback(hObject, eventdata, handles)
% hObject    handle to edit19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit19 as text
%        str2double(get(hObject,'String')) returns contents of edit19 as a double


% --- Executes during object creation, after setting all properties.
function edit19_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit20_Callback(hObject, eventdata, handles)
% hObject    handle to edit20 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit20 as text
%        str2double(get(hObject,'String')) returns contents of edit20 as a double


% --- Executes during object creation, after setting all properties.
function edit20_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit20 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit21_Callback(hObject, eventdata, handles)
% hObject    handle to edit21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit21 as text
%        str2double(get(hObject,'String')) returns contents of edit21 as a double


% --- Executes during object creation, after setting all properties.
function edit21_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton8.
function pushbutton8_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton9.
function pushbutton9_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton10.
function pushbutton10_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in popupmenu6.
function popupmenu6_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu6 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu6


% --- Executes during object creation, after setting all properties.
function popupmenu6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton12.
function pushbutton12_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton12 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles = guidata(hObject);
try,
  
  Xtrain=(load(get(handles.traininput,'String')));
  Ytrain=(load(get(handles.trainoutput,'String')));  
    
  if isstruct(Xtrain)
    Xtrain=struct2cell(Xtrain);
    Xtrain = Xtrain{1};
  end
  
  if isstruct(Ytrain)
    Ytrain=struct2cell(Ytrain);
    Ytrain = Ytrain{1};
  end
  
catch,
    Xtrain = [];Ytrain=[];
end

if length(Xtrain) == 0 | length(Ytrain) == 0
  waitfor(errordlg('Cannot find the training data or the file is not in right format.','Missing Data'));
  return
end

Ytrain = Ytrain(:,1);

handles.meanInput = mean(Xtrain);
handles.meanOutput = mean(Ytrain);
handles.stdInput = std(Xtrain);

Xtrain = (Xtrain - repmat(handles.meanInput,size(Xtrain,1),1) )./repmat(handles.stdInput,size(Xtrain,1),1);
Ytrain = (Ytrain - repmat(handles.meanOutput,size(Ytrain,1),1) );

method = get(handles.method,'String');
method = method{get(handles.method,'Value')};
cost = get(handles.cost,'String');
cost = cost{get(handles.cost,'Value')};
set(handles.pushbutton15,'Enable','On');
set(handles.pushbutton17,'Enable','On');

%----------------------------
%the following need a special treatment

 handles.projection = [];
    handles.scalings = [];

if isequal(method,'scaling')   
   handles.inputs_selected = [1:size(Xtrain,2)];
   if length(handles.kmaxknn) == 0
     [handles.scalings]=diag(scale(Xtrain,Ytrain));
     else
     [handles.scalings]=diag(scale(Xtrain,Ytrain,handles.kmaxknn));
   end
   set(handles.SIS,'String','Scalings available by saving');
   guidata(hObject,handles); 
   return; 
end

if isequal(method,'PLS')
    c=[];P={};    
    for j=1:min([size(Xtrain,2)-1 100])
        [Xp,T,P{j}] = pls(Xtrain,Ytrain,j);
        c(j)=LL(Xp,Ytrain);
    end
    [m,j]=min(c);
    handles.projection = P{j};
    set(handles.SIS,'String','Scalings available by saving');
    handles.inputs_selected = [1:size(Xtrain,2)];
    guidata(hObject,handles);
    return;
end

if isequal(method,'no input selection')
    
   handles.inputs_selected = [1:size(Xtrain,2)];
   set(handles.SIS,'String',num2str(handles.inputs_selected));
   guidata(hObject,handles); 
   return; 
end

if isequal(method,'ARD')
    
   handles.inputs_selected = ARDIS(Xtrain,Ytrain)';
   set(handles.SIS,'String',num2str(handles.inputs_selected));
   guidata(hObject,handles);
   return;
end 

%--------------------------------

%Forward Selection
if isequal(method,'forward selection') 
    
    if isequal(cost,'k-NN')
        if length(handles.kmaxknn) == 0
            [inputs,c]=FS(Xtrain,Ytrain,@KNN);
        else
            [inputs,c]=FS(Xtrain,Ytrain,@KNN,handles.kmaxknn);
        end
    end
    if isequal(cost,'LL')
        if length(handles.kmaxLL) == 0
            [inputs,c]=FS(Xtrain,Ytrain,@LL);
        else
            [inputs,c]=FS(Xtrain,Ytrain,@LL,handles.kmaxLL);
        end
    end
    
    if isequal(cost,'MI')
        [inputs]=FS(Xtrain,Ytrain,@negMI);
        %we choose the best inputs with LL
        c=[];
        for j=1:length(inputs)
           c(j)=LL(Xtrain(:,inputs(1:j)),Ytrain);
        end
    end
    if isequal(cost,'bootstrap 632')
        if length(handles.kmaxboot) == 0
            [inputs,c]=FS(Xtrain,Ytrain,@Boot632_KNN);
        else
            [inputs,c]=FS(Xtrain,Ytrain,@Boot632_KNN,handles.kmaxboot);
        end
    end
     
    
    [m,i]=min(c);
    handles.inputs_selected = inputs(1:i);
    set(handles.pushbutton15,'Enable','On');
end


%Backward selection
if isequal(method,'backward selection')
   
    if isequal(cost,'k-NN')
        if length(handles.kmaxknn) == 0
            [inputs,c]=BS(Xtrain,Ytrain,@KNN);
        else
            [inputs,c]=BS(Xtrain,Ytrain,@KNN,handles.kmaxknn);
        end
    end
    if isequal(cost,'LL') 
        if length(handles.kmaxLL) == 0
            [inputs,c]=BS(Xtrain,Ytrain,@LL);
        else
           
            [inputs,c]=BS(Xtrain,Ytrain,@LL,handles.kmaxLL);
        end
    end 
        
    if isequal(cost,'MI')
      [inputs]=BS(Xtrain,Ytrain,@negMI);
      %we choose the best inputs with LL
      c=[];
      for j=0:length(inputs)-1
         c(j+1)=LL(Xtrain(:,inputs(end:-1:j+1)),Ytrain);
      end
    end
    
    if isequal(cost,'bootstrap 632')
        if length(handles.kmaxboot) == 0
            [inputs,c]=BS(Xtrain,Ytrain,@Boot632_KNN);
        else
            [inputs,c]=BS(Xtrain,Ytrain,@Boot632_KNN,handles.kmaxboot);
        end
    end
   
    [m,i]=min(c(1:end));
    handles.inputs_selected = inputs(end:-1:i);
    set(handles.pushbutton15,'Enable','On');
end
    
 %Best-first  search
 if isequal(method,'best first')
      
     if isequal(cost,'k-NN')
         if length(handles.kmaxknn) == 0
             [inputs]=BFS(Xtrain,Ytrain,@KNN);
         else
             [inputs]=BFS(Xtrain,Ytrain,@KNN,1,0.001,5,[],handles.kmaxknn);
         end
     end
     if isequal(cost,'LL')
         if length(handles.kmaxLL) == 0
             [inputs]=BFS(Xtrain,Ytrain,@LL);
         else 
             [inputs]=BFS(Xtrain,Ytrain,@LL,1,0.001,5,[],handles.kmaxLL);
         end
     end   
     if isequal(cost,'bootstrap 632')
         if length(handles.kmaxboot) == 0
             [inputs]=BFS(Xtrain,Ytrain,@Boot632_KNN);
         else 
             [inputs]=BFS(Xtrain,Ytrain,@Boot632_KNN,1,0.001,5,[],handles.kmaxboot);
         end
     end 
     
     handles.inputs_selected = inputs;
   
 end

 %forward-backward search
 if isequal(method,'forward-backward selection')
  
     
     if isequal(cost,'k-NN')
         if length(handles.kmaxknn) == 0
             [inputs]=FSBS(Xtrain,Ytrain,@KNN,[]);
         else
             [inputs]=FSBS(Xtrain,Ytrain,@KNN,[],handles.kmaxknn);
         end
     end
     if isequal(cost,'LL')
         if length(handles.kmaxLL) == 0
             [inputs]=FSBS(Xtrain,Ytrain,@LL,[]);
         else 
             [inputs]=FSBS(Xtrain,Ytrain,@LL,[],handles.kmaxLL);
         end
     end   
     if isequal(cost,'bootstrap 632')
        if length(handles.kmaxboot) == 0
            [inputs,c]=FSBS(Xtrain,Ytrain,@Boot632_KNN,[]);
        else
            [inputs,c]=FSBS(Xtrain,Ytrain,@Boot632_KNN,[],handles.kmaxboot);
            
        end
    end
     
     handles.inputs_selected = inputs;
   
 end
 
 %genetic algorithm
 if isequal(method,'genetic IS')   
     
    if isequal(cost,'k-NN')
         if length(handles.kmaxknn) == 0
             [inputs]=GSearch(Xtrain,Ytrain,@KNN,[]);
         else
             [inputs]=GSearch(Xtrain,Ytrain,@KNN,handles.kmaxknn,[]);
         end
     end
     if isequal(cost,'LL')
         if length(handles.kmaxLL) == 0
             [inputs]=GSearch(Xtrain,Ytrain,@LL,[]);
         else 
             [inputs]=GSearch(Xtrain,Ytrain,@LL,handles.kmaxLL,[]);
         end
     end    
     
    if isequal(cost,'bootstrap 632')
        if length(handles.kmaxboot) == 0
            [inputs,c]=GSearch(Xtrain,Ytrain,@Boot632_KNN);
        else
            [inputs,c]=GSearch(Xtrain,Ytrain,@Boot632_KNN,handles.kmaxboot,[]);
        end
    end 
     
   handles.inputs_selected = inputs;
 end
 
if isequal(method,'LARS')
    inputs = LARS(Xtrain,Ytrain);
    c=[];
    for j=1:length(inputs)
      c(j)=LL(Xtrain(:,inputs(1:j)),Ytrain);
    end
    [m,i]=min(c);
    handles.inputs_selected = inputs(1:i);
end
 
set(handles.SIS,'String',num2str(handles.inputs_selected));

guidata(hObject,handles);

% --- Executes on button press in pushbutton14.
function pushbutton14_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton15.
function pushbutton15_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles = guidata(hObject);

try,    
  Xtrain=(load(get(handles.traininput,'String')));
  Ytrain=(load(get(handles.trainoutput,'String')));  
  if isstruct(Xtrain)
    Xtrain=struct2cell(Xtrain);
    Xtrain = Xtrain{1};
  end
  if isstruct(Ytrain)
    Ytrain=struct2cell(Ytrain);
    Ytrain = Ytrain{1};
  end
catch,
    Xtrain = [];Ytrain=[];
end

if length(Xtrain) == 0 | length(Ytrain) == 0
  waitfor(errordlg('Cannot find the training data.','Missing Data'));
  return;
end

try,
  Xtest=(load(get(handles.testinput,'String')));
  Ytest=(load(get(handles.testoutput,'String')));  
  if isstruct(Xtest)
    Xtest=struct2cell(Xtest);
    Xtest = Xtest{1};
  end
  if isstruct(Ytest)
    Ytest=struct2cell(Ytest);
    Ytest = Ytest{1};
  end 
catch,
    Xtest = [];Ytest=[];
end

if length(Xtest) == 0
  waitfor(errordlg('Cannot find the testing data.','Missing Data'));
  return;
end

h=gcf;

%normalization
Xtrain = (Xtrain - repmat(handles.meanInput,size(Xtrain,1),1))./repmat(handles.stdInput,size(Xtrain,1),1);
Ytrain = (Ytrain - repmat(handles.meanOutput,size(Ytrain,1),1) );
Xtest = (Xtest - repmat(handles.meanInput,size(Xtest,1),1))./repmat(handles.stdInput,size(Xtest,1),1);
Ytest = (Ytest - repmat(handles.meanOutput,size(Ytest,1),1) );

Xtrain = Xtrain(:,handles.inputs_selected);
Xtest = Xtest(:,handles.inputs_selected);

if length(handles.scalings > 0)
    Xtrain = Xtrain*handles.scalings;
    Xtest = Xtest*handles.scalings;
end

if length(handles.projection > 0)
    Xtrain = Xtrain*handles.projection;
    Xtest = Xtest*handles.projection;
end

if get(handles.grids,'Value') == 1
  [handles.modellssvm]=train_LSSVM(Xtrain,Ytrain,1);
else
  [handles.modellssvm]=train_LSSVM(Xtrain,Ytrain,0);
end
reset(gcf);

set(handles.pushbutton17,'enable','on');

if length(Ytest) > 0
    [handles.pred,handles.MSE]=LSSVMtest(Xtest,Ytest,handles.modellssvm);
    set(handles.MSEf,'String','MSE');
    set(handles.MSEf2,'String',num2str(handles.MSE));
end

if length(Ytest) == 0
    [handles.pred]=LSSVMtest(Xtest,Ytest,handles.modellsvm);
    handles.MSE = [];
    set(handles.MSEf,'String','');
    set(handles.MSEf2,'String','');
end


set(handles.pushbutton17,'Enable','On');
guidata(hObject,handles);

% --- Executes on button press in pushbutton17.
function pushbutton17_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles = guidata(hObject);
result = [];
result.kmaxkNN = handles.kmaxknn;
result.kmaxLL = handles.kmaxLL;
result.kmaxboot = handles.kmaxboot;
result.inputs = handles.inputs_selected;
result.MSE = handles.MSE;
if length(handles.pred) > 0
  result.pred = handles.pred+repmat(handles.meanOutput,size(handles.pred,1),1); %the outputs were meancentered
end
result.modellssvm = handles.modellssvm;

if length(handles.scalings) > 0
  result.scalings = handles.scalings;
end
if length(handles.projection) > 0
  result.projection = handles.projection;
end

uisave('result');


% --- Executes on button press in pushbutton18.
function pushbutton18_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton21.
function pushbutton21_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton23.
function pushbutton23_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function parfield_Callback(hObject, eventdata, handles)
% hObject    handle to parfield (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of parfield as text
%        str2double(get(hObject,'String')) returns contents of parfield as a double

handles = guidata(hObject);
contents = get(handles.cost,'string');
if size(contents,1) == 1
  s = contents;
else
  s = contents{get(handles.cost,'Value')};
end

if isequal(s,'k-NN')
    handles.kmaxknn = str2num(get(handles.parfield,'string'));
    if isequal(get(handles.parfield,'string'),'Default')
        handles.kmaxknn = [];
    end
end
if isequal(s,'LL')
    handles.kmaxLL = str2num(get(handles.parfield,'string'));
    if isequal(get(handles.parfield,'string'),'Default')
      handles.kmaxLL = [];
    end
end
if isequal(s,'bootstrap 632')
    handles.kmaxboot = str2num(get(handles.parfield,'string'));
    if isequal(get(handles.parfield,'string'),'Default')
      handles.kmaxboot = [];
    end
end


guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function parfield_CreateFcn(hObject, eventdata, handles)
% hObject    handle to parfield (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox2.
function checkbox2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox2


% --- Executes on button press in grids.
function grids_Callback(hObject, eventdata, handles)
% hObject    handle to grids (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of grids


