function GSVisualize(gen,costs,pop,parC,parG);
  
  subplot(2,1,1);
  imagesc(pop); colormap(gray);
  xlabel('inputs');
  ylabel('population');
  subplot(2,1,2);
  plot(1:gen, costs, 'b', 'LineWidth', 2);
  hold on
  Xtest=dlmread('orange/OJ_x_test.txt');
  Ytest=dlmread('orange/OJ_y_test.txt');
  test_cost = parG.costFun(Xtest,Ytest,parC);
  hold off
  set(gca,'XLim',[1,parG.termPar]);
  set(gca,'YLim',[0, 204]);
  xlabel('generation');
  ylabel('min cost');
  drawnow % visualize population
  print('-djpeg',['rand', sprintf('%05d',gen), '.jpg']);
