function [inds]=GSRouletteSelection(pop, cost, gen, parG)
% GSRouletteSelection   Roulette selection for GSearch
% 
% Implements interface inds=selFun(X,cost,gen,parG)
% 
% Parameters:
%   pop is is a Nxd matrix of row vectors of individuals (logicals)
%   cost is vector of costs for the N individuals (floats)
%   gen is the generation number (integer)
%   parG is parameter(s) for this funtion
% 
% Returns:
%   inds a 1xN matrix of indices of selected inputs
  
  cost(isinf(cost)) = 0; % 
  if sum(cost) == 0, 
    cost = ones(size(cost));
  end
  cpcost = cumsum(cost)/sum(cost);

  inds = zeros(1, parG.popSize);
  for k=1:parG.popSize,
    inds(k) = find(cpcost>rand,1);
  end

