function Y = GSBinXover(X, cost, gen, par)
% GSBinXover   Binary crossover for GSearch
% 
% Implements interface pop2=reprodFun(pop,cost,gen,par)
% 
% Parameters:
%   pop is is a Nxd matrix of row vectors of individuals (logicals)
%   cost is vector of costs for the N individuals (floats)
%   gen is the generation number (integer)
%   par is parameter(s) for this funtion
% 
% Returns:
%   pop2 a Nxd matrix of offspring of pop (logical)
%
% Note: N can be odd, in which case lonely people are their own 
%       offspring
  
  [N d] = size(X);
  Y = zeros(size(X));
  
  % Lonely individual is copied as it is
  if rem(N, 2),
    Y(N,:) = X(N,:);
    N = N - 1;
  end

  if N > 0,
    b = rand(N/2,d) < par;
    inds = randperm(N);
    X1 = X(inds(1:2:N), :);
    X2 = X(inds(2:2:N), :);
    Y1 = X1; Y1(b) = X2(b);
    Y2 = X2; Y2(b) = X1(b);
    Y(1:N, :) = [Y1; Y2];
  end
