function [Y]=GSBinMutation(X, cost, gen, par)
% GSBinMutation   Binary mutation for GSearch
% 
% Implements interface pop2=reprodFun(pop,cost,gen,par)
% 
% Parameters:
%   pop is is a Nxd matrix of row vectors of individuals (logicals)
%   cost is vector of costs for the N individuals (floats)
%   gen is the generation number (integer)
%   par is parameter(s) for this funtion
% 
% Returns:
%   pop2 a Nxd matrix of mutated individuals of pop (logical)
  
  Y = X;
  b = rand(size(Y)) < par;
  Y(b) = ~Y(b);
