function [pop] = GSBinInitialize(X, Y, parG);
% GSBinInitialize   Random init for binary string representation
% 
% Implements interface Y=initFun(X,Y, parG)
% 
% Parameters:
%    X is a Nxd matrix of N samples of d-dimensional input variables
%    Y is a Nx1 vector of output values
%    parG is a parameter struct for GSearch
%   
% Returns:
%    pop is a logical population matrix of size par.popSize x d
  
  pop = logical(randint(parG.popSize, size(X,2)));
  
    