function [inputs,cost] = FSBS(x, y,costfunction,initial,varargin)

%FSBS(forward-backward selection) with known function named costfunction 
%
%Params:
%x    The data as a Nxd matrix. d is the dimension of the input space.
%y    The outputs as a Nx1 matrix.
%initial    initial is the index vector of initially active inputs. Set [] if no inputs are specified
%
%
%Optional:depends on the costfunction used
%for example lazy learning and KNN, it is the kmax The maximum k. Default is 10% of the size of the data set.
% 
%Return:
%inputs  a vector which contains the indices of the inputs that are selected at the last step.
%costs: the corresponding value of the used costfunction 



[N, d] = size(x);

indexL = zeros(1,d);
indexL(initial) = 1;


better = 1;
counter = 0;
costFinal = [];
neigh=[];

while(better)
  
  for i = 1:d
    indexS = indexL;
    indexS(i) = -1 * indexS(i) + 1;
    indexS = indexS .* (1:d);
    indexS(find(indexS == 0)) = [];
    
    if isempty(indexS)
      continue;
    end

    xx = x(:, indexS);

    cost_general(i) = costfunction(xx, y, varargin{:});
  end

  [aa, bb] = min(cost_general);
  indexL(bb) = -1 * indexL(bb) + 1;
  neigh=[neigh,bb];
  
  if length(costFinal) > 0
    if min(costFinal) > aa
      counter = 0;
    else
      counter = counter + 1;
    end
  end
  
  costFinal = [costFinal aa];
  
  if counter == 3
    better = 0;
  end
end
for i=0:2
indexL(neigh(end-i)) = -1 * indexL(neigh(end-i)) + 1;
end

inputs = indexL .* (1:d);
inputs(find(inputs == 0)) = [];

cost= costFinal(end-3);






