function [inputs,costs] = FS(x,y,costfunction,varargin)
%FS(forward selection) with known function named costfunction
%
%Params:
%x    The data as a Nxd matrix. d is the dimension of the input space.
%y    The outputs as a Nx1 matrix.
%
%Optional:depends on the costfunction used
%for example lazy learning and KNN, it is the kmax The maximum k. Default is 10% of the size of the data set.
% 
%Return:
%inputs  a vector which contains the indices of the inputs that are selected at each step.
%costs: the corresponding values of the used costfunction

d=size(x,2);

xm=0*x;

xd=x;

counter=1;

index=1:d;

for j=0:(d-1);
    
    for i=1:(d-j);
        xs=[xm,xd(:,i)]; 
        gam(i)=costfunction(xs,y,varargin{:});
    end
    
    [I1,I2]=sort(gam);
    
    coststemp(counter)=I1(1);
    
    k=I2(1);
    
    inputstemp(counter)=index(k);
    
    index=index([1:(k-1) (k+1):end]); 
       
       
    xm(:,j+1)=xd(:,k);
    
    xd=xd(:,[1:(k-1) (k+1):end]);        
        
    counter=counter+1;
    
    gam=0;
    
end
  

inputs=inputstemp;

costs=coststemp;
