function [inputs,costs] = BS(x,y,costfunction,varargin)
%BS(backward selection) with known function named costfunction
%
%Params:
%x    The data as a Nxd matrix. d is the dimension of the input space.
%y    The outputs as a Nx1 matrix.
%
%Optional:depends on the costfunction used
%for example lazy learning and KNN, it is the kmax The maximum k. Default is 10% of the size of the data set.
% 
%Return:
%inputs  a vector which contains the indices of the inputs that are pruned at each step.
%costs: the corresponding values of the used costfunction


d=size(x,2);

counter=1;

xm=x;

index=1:d;

while d~=0
    
    for i=1:d;
        
        xs=xm(:,[1:(i-1) (i+1):end]); 
        
        gam(i)=costfunction(xs,y,varargin{:});
        
    end
    
    [I1,I2]=sort(gam);
    
    coststemp(counter)=I1(1);
    
    k=I2(1);%find the min dimension
    
    inputstemp(counter)=index(k);
    
    index=index([1:(k-1) (k+1):end]); 
    
    xm=x(:,[1:(k-1) (k+1):end]); 
    
    counter=counter+1;
    
    d=d-1;
    
    gam=0;
    
end


inputs=inputstemp;

costs=[costfunction(x,y,varargin{:}) coststemp(1:end-1)];
