%% T-61.2010 Datasta tietoon / T#1 / 5
% Jukka Parviainen, 9.11.2006 

%% Konvoluutio
% Konvoluutio on trke signaalinksittelyn operaatio,
% sill se vastaa signaalin suodattamista.
%
% Kahdelle lukujonolle voidaan laskea konvoluutio,
% katso esim. paperilaskarien #1 / 1:

esim_f = [2 -1]
esim_h = [-1 2 1]
esim_g = conv(esim_f, esim_h)

%% Lue oma nitiedosto tarvittaessa sisn Matlabiin

%[f, Fs, nbits] = wavread('kiisseli.wav'); 

%% Signaalin suodattaminen
% Signaali f voidaan suodattaa suotimen impulssivasteella h
% ja saada siten lopputulokseksi suodatettu signaali g.
%
%             |-------|
%     f  ---> |   h   | --->  g
%             |-------|
%
% Luodaan aluksi suotimen impulssivastejono h fir1-komennolla.
% Impulssivastejonon pituus on 70 merkki (jrkevt arvot 2..200). 
% Toisessa argumentissa 2000 on alipstsuotimen rajataajuus:
% tt alemmat taajuudet jtetn ja korkeammat vaimennetaan.
%
% Sen jlkeen konvoloidaan signaali suotimen impulssivasteen kanssa
% ja saadaan ulostulo.

h = fir1(70, 2000/(Fs/2));
g = conv(f, h);

%% Katso suodatettua signaalia

t1 = [1 : length(f)]/Fs;
t2 = [1 : length(g)]/Fs;

figure(51); 
clf;
plot(t1, f, 'b', t2, g, 'k');
grid on;
xlabel('aika (s)');
legend({'Alkuperinen f','Suodatettu g'});
title('Alkuperinen ja suodatettu signaali');

%% Zoomattu kohta /i/
% Zoomataan samaan kohtaan, mist /i/ oli poimittu
% edellisess demossa.
%
% Huomaa kuinka signaali "pehmenee" alipstsuodatuksessa.
% Viive johtuu suotimesta ja on (70/2)/Fs sekuntia eli
% noin 1.6 ms.

figure(52); 
clf;
plot(t1, f, 'b', t2, g, 'k');
grid on;
xlabel('aika (s)');
legend({'Alkuperinen f','Suodatettu g'});
title('Alkuperinen ja suodatettu /i/');

dummy = f(indA:indB);   % indA ja indB kohdasta dt_t1_m4.m
dummyn = min(dummy);
dummyx = max(dummy);
axis([indA/Fs indB/Fs dummyn dummyx]);

%% Taajuustasossa
% Ylimmss ikkunassa alkuperisen signaalin spektrogrammi.
% Keskell suotimen amplitudivaste.
% Alhaalla suodatetun signaalin spektrogrammi.
%
% Jos kytetty alipstsuodinta 2000 Hz:n rajataajuudella,
% korkeammat taajuudet pitisi olla vaimentuneet.

figure(53);
clf;
subplot(3,1,1)
specgram(f, [], Fs); 
colormap(gray);
colorbar
title('Sisntulosignaalin f spektogrammi');

subplot(3,1,2)
[H,W] = freqz(h,1,1024,Fs);
plot(W, abs(H));
title('Suotimen amplitudivaste');
xlabel('taajuus (Hz)');
grid on;
axis([0 W(end) -0.1 1.2]);

subplot(3,1,3);
specgram(g, [], Fs);
colormap(gray);
colorbar
title('Suodatetun signaalin g spektogrammi');

%% Kuuntele 

soundsc(g, Fs);   % suodatettu
% soundsc(f, Fs);   % alkuperinen

%% Suodatuksesta demo taajuustasossa
% Katso 
% http://www.cis.hut.fi/Opinnot/T-61.3010/Demo/esim1.shtml
