%% T-61.2010 Datasta tietoon / T#1 / 2
% Jukka Parviainen, 9.11.2006 (esim12.m 2001-2004)

%%
% Kytetn signaalina puhetta. Esitelln jatkuva signaali
% x(t), huomataan, ett se on tietokoneessa pelkki numeroita,
% joita voidaan ksitell yksinkertaisin tavoin. Tehdn 
% muutama tllainen operaatio.

%close all;      % sulkee kaikki ikkunat
%clc;            % puhdistaa komentoruudun

%% Lue nisignaali 
% Luetaan nisignaali sisn Matlabiin ellei jo ole.

%[f, Fs, nbits] = wavread('kiisseli.wav'); 
disp(['Kesto: ' num2str(length(f)/Fs) ' sekuntia.']);

%% Piirretn nisignaalin f arvot

figure(21); clf;
t = [0 : length(f)-1] / Fs;
ku1 = plot(t, f);       % voidaan piirt
title('Signaali f(t)'); % siis oikeasti digitaalinen x[n]
xlabel('aika (sekunnit)');
ylabel('voimakkuus');
grid on;
axis([0 t(end) 1.1*min(f) 1.1*max(f)]);

%%
% Voit zoomata ruudulla valitsemalla ylpalkista
% suurennuslasin ja vet hiiren nappi pohjassa kapean ikkunan.
% Oikealla hiiren nppimell pset takaisinpin.

%% Zoomataan ptk

disp(['Zoomataan 400 nytett, joka vastaa ' num2str(400/Fs) ' s']);

aa = round(0.4*length(f));
%aa = <jokin ksin annettu kokonaisluku>;
ab = aa+399;   % ?! Index exceeds matrix dimensions

figure(21);    % listn pun. viivat zoomaukseen
li1 = line([aa ab; aa ab]/Fs, [-1 -1; 1 1]);
set(li1,'Color',[1 0 0],'LineWidth',2);
legend({'signaali','zoom-alku','zoom-loppu'});
    
figure(22); clf;
t = [0 : length(f)-1] / Fs;
plot(t, f);       
title('Signaali f(t) zoomattuna kuvasta Fig 21'); 
xlabel('aika (sekunnit)');
ylabel('voimakkuus');
grid on;
axis([t(aa) t(ab) 1.2*min(f(aa:ab)) 1.2*max(f(aa:ab))]);

%% Tietokoneen signaali on digitaalista

ba = aa+30;  % hatusta vedetyt rajat
bb = ba+50;  % 51 merkki pitk "nuppineulaketju"

figure(22);   % listn pun. viivat zoomaukseen
li1 = line([ba bb; ba bb]/Fs, [-1 -1; 1 1]);
set(li1,'Color',[1 0 0],'LineWidth',2);

figure(23); clf;
stem(t(ba:bb), f(ba:bb));  % digitaalinen "nuppineula"
title('Sekvenssi f[n] zoomattuna kuvasta Fig 22');
xlabel('aika (sekunnit)');
ylabel('voimakkuus');
grid on;
axis([t(ba) t(bb) 1.2*min(f(ba:bb)) 1.2*max(f(ba:bb))]);

tt0 = text(t(ba), f(ba), ['f[' num2str(ba) ']']);
tt4 = text(t(ba+5), 1.05*min(f(ba:bb)), ['f[' num2str(ba) '] = ' num2str(f(ba))]);
tt1 = text(t(ba+10), f(ba+10), ['f[' num2str(ba+10) ']']);
tt2 = text(t(ba+20), f(ba+20), ['f[' num2str(ba+20) ']']);
tt3 = text(t(ba+30), f(ba+30), ['f[' num2str(ba+30) ']']);
tt5 = text(t(ba+35), 1.05*min(f(ba:bb)), ['f[' num2str(ba+30) '] = ' num2str(f(ba+30))]);


%% Nytteenottotaajuus
% Digitaaliseen sekvenssiin voi siis liitty
% fysikaalinen suure, nytteenottotaajuus,
% joka kertoo kuinka monta nytett esiintyy
% yhden sekunnin aikana. Nytteenottotaajuuden Fs
% yksikk on Hertz (Hz = 1/s). 
%
% Toisaalta nytteenottotaajuuden knteisluku on nytevli Ts.
%
% Signaalista voidaan havaita enintn Fs/2 Hz:n taajuuksia.

%% Signaaliarvot pelkki lukuarvoja
% Tulostetaan ptk signaalia ja huomataan, ett 
% se todellakin vain on pelkki numeroita.

f(1:1000)   % ensimmiset tuhat nytett
f(end)      % lukujonon viimeinen nyte

%% Kuunnellaan!

soundsc(f, Fs);  %..mutta kuuntele! 

%% Soitetaan lukujonoa eri nopeuksilla
% 1 < kerroin < 2  --> pikkuorava
% 0.5 < kerroin < 1  --> Lordi

kerroin = 1.3;
soundsc(f, kerroin*Fs);

%% Numerojonon muokkaus
% Numerojonoa voi ksitell monin eri tavoin...

win2 = linspace(1,0,round(0.5*length(f)));
win1 = ones(1, length(f)-length(win2));
win  = [win1 win2];
f2 = f.*win'; % vaimentaminen, fade out

figure(24); clf;
plot(t,f2);
title('"Fade-in+out", vaimennettu signaali f(t), kts kuva Fig 21');
xlabel('aika (sekunnit)'); 
ylabel('voimakkuus');
grid on;
axis([0 t(end) 1.1*min(f2) 1.1*max(f2)]);

figure(21); 
li3 = line([0 t(round(0.5*length(f))) t(end)],[max(f) max(f) 0]);
set(li3,'Color','g','LineStyle','-.','LineWidth',3);
legend({'signaali','zoom-alku','zoom-loppu','"fadaus-ikkuna"'});

soundsc(f2,Fs); 

%% Jonon kntminen ympri
% Koska sekvenssi on vain lukuja f[n]
% voidaan jrjestys vaihtaa vastakkaiseksi f[N-n].

f3 = flipud(f);   % [0.2 0.5 -0.1] -> [-0.1 0.5 0.2]
soundsc(f3,Fs);  
