%% T-61.2010 Datasta tietoon / T#1 / 1
% Jukka Parviainen, 9.11.2006

%% nen nauhoitus / Recording
% Nauhoita sana "kiisseli"
% iloisella, surullisella, vihaisella, innostuneella nensvyll.
% PAINOTA ensimmisen tavun /i/-nnett.

% nytteenottotaajuus / sampling frequency:
% voidaan havaita taajuudet Fs/2:een asti /
% you can observe frequencies up to Fs/2.
Fs = 22050;   % Hz

% kesto / duration
T = 2.5; % s

% Nauhoita suoraan Matlabista / Record:
f     = wavrecord(T*Fs, Fs, 1, 'single');
f     = double(f); % muutetaan tyyppi double:ksi
nbits = 16;

% Voit vaihtoehtoisesti nauhoittaa mys WAV-muotoisena.
% Windowsissa "KYNNIST - OHJELMAT - APUOHJELMAT - VIIHDE - NINAUHURI".
% Talleta mieluiten nytteenottotaajuudella 22050 Hz, mono, 16 bit.
%
% Lue tiedosto sisn Matlabissa komennolla:
% [f, Fs, nbits] = wavread('<tiedostonimi.wav>');
% [f, Fs, nbits] = wavread('kiisseli.wav');         % esimerkiksi
%
% Tss 
%   f:ss on nytejono
%   Fs on nytteenottotaajuus
%   nbits kertoo kuinka monta bitti kytetn 
%     yhden numeron esittmiseen WAV-tiedostossa

%% Varmistetaan f:n muoto
% Halutaan, ett nisignaali on varmasti "mono" ja
% pystyvektori.

if (size(f,1) < size(f,2))
    f = f';
end;
if (length(f) ~= prod(size(f)))
    f = f(:,1);
end;

%% Piirretn nisignaali / Plotting the signal
% Kutsuu funktiota "dt_t1_plotsignal", joka
% piirt signaalin ylimpn ikkunaan,
% keskimmiseen energian 50 ms:n ikkunoissa,
% alimmaiseen signaalin, josta leikattu "tyhj"
% (pieni energia) sek alusta ett lopusta
%
% Energia N-merkki pitkss lukujonossa:
%
%  $$E = \sum_{i=1}^N x(i)^2$$

figure(11);     % avaa tai aktivoi ikkuna nro 11 / open or activate Fig 11
clf;            % puhdista ruutu / clear figure
kynnys = 1;     % punainen vaakaviiva -
                % jos ongelmia, pienenn lukua
f = dt_t1_plotsignal(f, Fs, kynnys);

%% Kuunnellaan / Listen to the signal
soundsc(f, Fs);

%% Talletetaan WAV-tiedostoksi / Save the file
% Voidaan tarvittaessa tallentaa WAV-tiedostoksi
% joko:
%wavwrite(f, Fs, nbits, '<omatiedostonimi.wav>');
% tai generoi nimi:
%wavwrite(f, Fs, nbits, ['kiisseli_' num2str(round(1E6*rand)) '.wav']);
